### 背景介绍



插片式 I/O 模组采用耦合器模块、电源模块和 I/O 模块组合的结构。耦合器将可扩展的 I/O 模块连接到实时工业以太网系统，背板采用 SC-bus 总线，耦合器模块负责现场总线通讯，从而实现了各种 I/O 模块与耦合器/控制器实时交换数据的功能。

 

本实验以 metafacture1.0.4.0 连接 SX5 工智机及插片式 IO 模组，验证 IO 模组与控制器实现实时数据交互功能

 

下载：🧷**[SF1000本地I/O操作文档【20241024】](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/attachments/SF1000本地IO操作手册.zip "SF1000本地IO操作手册.pdf")**

 

---

### 实验设备及型号

硬件： SX5 系列工智机 I/O模块及其他



| 模块类型 | 产品 |
|---|---|
| 厂家提供的N32 设备 | N32 |
| 数字量 I/O 模块 | SRC2116 16 通道数字量输出模块，NPN 型，24VDC，0.5A |
| SRC2216 16 通道数字量输出模块，PNP 型，24VDC，0.5A |
| SRC1116 16 通道数字量输入模块，NPN 型，24VDC，滤波3ms |
| SRC1216 16 通道数字量输入模块，PNP 型，24VDC，滤波3ms |
| 模拟量 I/O 模块 | SRC3118 8 通道模拟量电压输入模块 |
| SRC3138 8 通道模拟量电流输入模块 |
| SRC4018 8 通道模拟量电压输出模块 |
| SRC4038 8 通道模拟量电流输出模块 |
| 温度采集模块 | SRC3804 4 通道热电阻、热电偶温度采集模块 |
| 功能模块 | SRC5001 24V 单端增量式编码器计数模块 |
| SRC5031 5V 差分增量式编码器计数模块 |
| SRC5041 SSI 编码器计数模块 |
| SRC6041 RS485/RS422/RS232 网关模块 |



软件：metafacture1.0.4.0

 

 

---

### 实验接线图

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/6747e800c8e46.png)

如上图，将网线接入网口，电源接口接入电源，当 N32模块接入电源时工智机也会上电。

---

### 实验步骤

1.新建工程新建一个标准工程，具体可参考该文档新建工程

2.连接设备   
2.1. 将显示屏连接工智机并查看其 ip 地址，具体可参考查看工智机 IP 地址   
2.2. 在 metafacture 中通过输入 IP 地址来连接 PLC，具体可参考连接 PLC

3.添加设备描述文件   
添加下面的本地 IO 的设备描述文件，具体可参考该文档添加/删除/导出设备   
  
4.添加本地 IO 插件

  
方式一：本地更新（注意：此方式需关闭 metafacture 软件）   
1\. 在开始菜单中，在 metafacture 文件夹中找到“metafacture plugin manager”并打   
开，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/6747e98741fed.png)

2\. 下载并解压本地 IO 插件安装包

\[sinsegye.ide.localioconfiguration.plugin (1).zip\]

3.打开“metafacture plugin manager”，点击“install plug”，如下图

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/6747e9c451fed.png)

4.在弹出的界面中，选择已解压好的文件

“sinsegye.ide.localioconfiguration.plugin.dll”，如下图，点击打开。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492b138d1bb.png)

5\. 此时会在界面中出现本地 IO 插件 1.0.0.2，如下图。点击关闭即可。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492b24d16c3.png)

6\. 点击【profiles】中找到“sinsegye.ide.localioconfiguration”，双击打开，在弹窗中点击【newest version】-【OK】，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492ecdcfe81.png)

最终效果图如下，点击【close】即可。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492edd6caf4.png)

方式二

1.点击菜单栏中的“工具”-“在线更新工具”。

2\. 在弹出窗口中点击“test”，找到“sinsegye.ide.localioconfiguration.plugin”，并安装， 如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492f0e9a54f.png)

3.再次打开 metafacture，选中“application”-“添加对象”-“本地 io 配置界面”，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492f1ee58d3.png)

4.弹出界面中点击“添加”，继续点击“确定”，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492f2e6048a.png)![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492f3159e40.png)

5.在MetaFacture中会弹出如下界面，表明添加成功

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492f5006ad3.png)

5.添加本地I/O模块

5.1如下图，已将相关的 io 模块连接在工智机后面。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492f957029b.png)

5.2在 metafacture 中打开“本地 IO 配置界面”，在右侧 IO 模块区域，分别依次拖入对应的模块（注意：拖入的顺序必须与实际硬件设备的顺序一致）如下图

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492fa483196.png)

5.3点击“生成代码”-“登录”-“启动”，可也看到添加的模块变为绿色（若未变绿，则需检查模块顺序）如下图

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492fb674383.png)

6.数字输出输入模块测试

6.1在设备硬件连接好并且“本地 io 配置界面”为运行状态，可以分别查看 2116 与 1116 的参数，如下图

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492fcd7bb5a.png)“SRC2116”为数字量输出模块意思是：该模块可接收工智机发送的数据，并将该数据发送出去。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67492fd9b877c.png)

“SRC1116”为数字量输入模块意思是：该模块可接收其他输出模块的数据，其对应的指示灯随着亮起。

6.2硬件连接图

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/traffic/67492ff3a2a15.png)

6.3打开 metafacture，在“PLC\_PRG”中代码区，输入 iogvl.MI\_1116\_1; 为了引用 io模块的变量。运行程序，打开“IOGVL”界面，将 2116 通道 5 赋值为 true 并写入，随机1116 的通道 11 即变为 true，如下图

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/674930107f6ac.png)

硬件设备效果图如下：对应的指示灯已亮起

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/traffic/6749301f9e7c9.png)

7.模拟量的码值和数据的切换显示

7.1添加相关的模拟量硬件模块在工智机上，如下图，本案例选取了 SRC3138——8 点模拟量输入、SRC4038——8 通道电流输出。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/6749303d8b906.png)

7.2在 metafacture 中添加对应的 io 模块，如下图。（注意：保证与实物顺序的一致）

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67493060dd978.png)

7.3点击【生成代码】-【登录】-【运行】，可在“本地 io 配置界面”中看到模块已变成绿色，如下图

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67493076283c5.png)

7.4码值显示

点击【本地 io 配置界面】-【通道基本参数】，可看到量程列中显示0~20mA(0~65535)，其中括号中的数值称之为码值。

码值为工业现场中特殊的数值，码值显示即在运行状态下，输入输出显示的数字为 0~65535 的数字。

  
码值对应关系表

|  | SRC4038——8 通道电流输出 | SRC3138——8 点模拟量输入 |
|---|---|---|
| 量程 | 0~20mA(0~65535)    4~20mA(0~65535) | 0~20mA(0~65535)    4~20mA(0~65535) |
| 对应值 | 65535 | 65535 |
| 对应值 | 0 | 0 |
| 量程 | 0~20mA(0~24678)    4~20mA(0~24678) | 0~20mA(0~24678)    4~20mA(0~24678) |
| 对应值 | 0 | 0 |
| 对应值 | 24678 | 24678 |

在【本地 io 配置界面】，点击右上角【显示码值】/【显示数据】，当界面为【显示码值】则已切换为【显示码值】状态，如下图是显示码值。

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67493122a954c.png)

在【IOGVL】窗口，在 4038 的第五通道、第六通道分别输出 100 和 65535，并写入，那么可看到 3138 的第一通道和第三通道的的值变为 75—76(码值存在上下浮动的情况)和 65535，如下图

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67493136df523.png)

在第五通道输入 0 并写入，可看到第一通道变为 0，这样是符合预期的。

同理，若将 3138 的量程修改为 0~20mA(0~24678)，4038 的量程为0~20mA(0~65535)，那么当 4038 输入 65535 时，3138 会输出 24678，如下图（在修改量程时候，需退出登录再修改）

![](https://resource.helplook.net/docker_production/3648ne/article/VhFjcwYt/67493152224ff.png)

注意：输入输出模块的量程只能同时为 0~20mA 或 4~20mA 中的一种，不可一个模块为 0~20mA，一个模块为 4~20mA